from flask import Flask
from flask import Blueprint,render_template,request,url_for
from werkzeug.utils	import redirect
import os
from chfi.models import	Sensor
from datetime import datetime
import hashlib
import os
from PIL import Image
import piexif
import platform

bp = Blueprint('forensic', __name__, url_prefix='/forensic')

def	calculate_hash_string(text,	algorithm="md5"):
	"""문자열 해시 계산"""
	h =	hashlib.new(algorithm)
	h.update(text.encode("utf-8")) #1 : c4ca4238a0b923820dcc509a6f75849b(32자)
	return h.hexdigest()

def	calculate_hash_file(file, algorithm="md5"):
	"""파일 해시 계산	(chunk 단위로)"""
	h =	hashlib.new(algorithm)
	while chunk	:= file.read(8192):
		h.update(chunk)
	file.seek(0)  #	파일 포인터 초기화 (다시 사용 가능하도록)
	return h.hexdigest()

def analyze_image_metadata(image_path):
    if not os.path.exists(image_path):
        print(f"파일이 존재하지 않습니다: {image_path}")
        return

    # 파일 기본 정보
    file_info = os.stat(image_path)
    file_size_kb = file_info.st_size / 1024

    print(f"\n[파일 정보]")
    print(f"파일 경로: {image_path}")
    print(f"파일 크기: {file_size_kb:.2f} KB")
    print(f"확장자: {os.path.splitext(image_path)[1]}")


@bp.route('/',methods=["GET","POST"])
def	index():
	convert_result = ""
	active_tab = "home"	 # 기본값은	해시 탭
	
	if request.method == "POST":
		active_tab = request.form.get("active_tab",	"home")	 # 탭 정보	가져오기
		
		if active_tab == "home":
			option = request.form.get("convert_select")	 # string or file

			if option == "string":
				input_text = request.form.get("inputText", "")
				if input_text:
					result = calculate_hash_string(input_text)
					return render_template('forensic/index.html',convert_text=input_text,convert_result=result,active_tab=active_tab)
			elif option	== "file":
				uploaded_file =	request.files.get("inputFile")
				if uploaded_file and uploaded_file.filename	!= "":
					result = calculate_hash_file(uploaded_file)
					return render_template('forensic/index.html',convert_text=uploaded_file.filename,convert_result=result,active_tab=active_tab)
		elif active_tab	== "menu1":
			print("start1")
			try:
				current_os = platform.system()
				if current_os == "Windows":
					print("start2")
					# 예: Windows의 이미지 경로
					image_path="C:\\projects\\flask\\chfi\\static\\img\\meta4.PNG"
				elif current_os == "Linux":
					# 예: Linux의 이미지 경로
					image_path = "/home/yourname/Pictures/example.jpg"
				else:
					print(f"지원되지 않는 운영체제입니다: {current_os}")
					return render_template('forensic/index.html', convert_result="지원되지 않는 운영체제", active_tab=active_tab)
					#return None				
				#image_path="C:\\projects\\flask\\chfi\\static\\img\\meta1.jpg"
				analyze_image_metadata(image_path)

				metadata = {}

				with Image.open(image_path) as img:
					metadata["파일명"] = os.path.basename(image_path)
					metadata["포맷"] = img.format
					metadata["모드"] = img.mode
					metadata["해상도"] = f"{img.size[0]} x {img.size[1]}"
					metadata["위도"] = "1"
					metadata["경도"] = "2"									
					print(metadata)
					gps_info = {"위도":1,"경도":1}					
					exif_bytes = img.info.get("exif")
					exif_metadata = {}

					if exif_bytes:
						exif_data = piexif.load(exif_bytes)
						for ifd in exif_data:
							for tag in exif_data[ifd]:
								tag_name = piexif.TAGS[ifd].get(tag, {"name": tag})["name"]
								value = exif_data[ifd][tag]
								if isinstance(value, bytes):
									try:
										value = value.decode()
									except:
										value = str(value)
								exif_metadata[tag_name] = value
					metadata["EXIF"] = exif_metadata
					'''
						gps_data = exif_data.get("GPS", {})
						if gps_data:
                            lat = gps_data.get(piexif.GPSIFD.GPSLatitude)
                            lat_ref = gps_data.get(piexif.GPSIFD.GPSLatitudeRef, b'N').decode()
                            lng = gps_data.get(piexif.GPSIFD.GPSLongitude)
                            lng_ref = gps_data.get(piexif.GPSIFD.GPSLongitudeRef, b'E').decode()

                            if lat and lng:
                                gps_info["위도"] = dms_to_degrees(lat, lat_ref)
                                gps_info["경도"] = dms_to_degrees(lng, lng_ref)
						
                    metadata["EXIF"] = exif_metadata						
					'''

					
				#convert_result = exif_metadata
				convert_result = metadata				
				print(convert_result)
				return render_template("forensic/index.html", convert_result=convert_result,gps_info=gps_info,active_tab=active_tab)

			except Exception as e:
				print(f"이미지를 처리할 수 없습니다: {e}")
				convert_result = {"오류": str(e)}

		elif active_tab	== "menu2":
			convert_result = "암호"

		elif active_tab	== "menu3":
			convert_result = "레지스트리"


	return render_template("forensic/index.html", convert_result=convert_result,active_tab=active_tab)
		
	
	
	

