from flask import Flask,request,jsonify
from flask_migrate import Migrate
from flask_sqlalchemy import SQLAlchemy
import os
import config

db = SQLAlchemy()
migrate = Migrate()
def create_app():
  
  app = Flask(__name__)
  #app.config.from_object(config)
  app.config.from_envvar('APP_CONFIG_FILE')  
  #ORM
  db.init_app(app)
  migrate.init_app(app,db)
  from . import models
  #블루프린터
  from .views import mainv,monitorv,authv,iotv,securityv,forensicv,boardv,licensev
  app.register_blueprint(mainv.bp)
  app.register_blueprint(monitorv.bp) 
  app.register_blueprint(authv.bp)
  app.register_blueprint(iotv.bp)
  app.register_blueprint(securityv.bp)
  app.register_blueprint(forensicv.bp)
  app.register_blueprint(boardv.bp)  
  app.register_blueprint(licensev.bp) 
  return app