from flask import Blueprint,render_template
import requests
import random
import time
import sqlite3

bp = Blueprint('monitor', __name__, url_prefix='/monitor')


def get_latest_data():
        conn = sqlite3.connect('/home/master/projects/flask/hospital.db')
        cursor = conn.cursor()
        cursor.execute('SELECT * FROM sensor ORDER BY regdate DESC LIMIT 10')  # 최근 5개의 데이터 가져오기
        data = cursor.fetchall()        
        conn.close()
        return data


# 더미 초음파 센서 값 생성
def get_ultrasonic_value():
        return random.uniform(10.0, 200.0)  # 예시: 10cm ~ 200cm 사이의 거리


#
#def get_ultrasonic_value():
#        return round(sensor.distance*100,2)  # 예시: 10cm ~ 200cm 사이의 거리


# 더미 온도 센서 값 생성
def get_temperature_value():
        return random.uniform(20.0, 30.0)  # 예시: 20°C ~ 30°C

# 더미 습도 센서 값 생성
def get_humidity_value():
        return random.uniform(40.0, 60.0)  # 예시: 40% ~ 60% 습도


@bp.route('/log')
def log():
        return render_template('/monitor/log.html')
        
        
@bp.route('/sensor')
def sensor():
        ultrasonic_value = get_ultrasonic_value()  # 초음파 센서 값
        temperature_value = get_temperature_value()  # 온도 센서 값
        humidity_value = get_humidity_value()  # 습도 센서 값
        #data = get_latest_data()
        #emit('update_value', {'value': value})
        return render_template('/monitor/sensor.html',ultrasonic_value=ultrasonic_value,temperature_value=temperature_value, humidity_value=humidity_value)
        #return render_template('/monitor/sensor.html',ultrasonic_value=ultrasonic_value,temperature_value=temperature_value, humidity_value=humidity_value,data=data)
        #return render_template('/monitor/sensor.html',distance=distance, data=data,ultrasonic_value=ultrasonic_value, 
        #                   temperature_value=temperature_value, humidity_value=humidity_value)
