from flask import Flask
from flask import Blueprint,render_template,request,url_for
from werkzeug.utils import redirect
import os
from chfi.models import Sensor
from datetime import datetime
import pymysql

bp = Blueprint('iot', __name__, url_prefix='/iot')

# DB 연결 설정
db_config = {
    "host": "localhost",
    "user": "root",
    "password": "1234",
    "db": "sensor_db",
    "charset": "utf8mb4"
}

@bp.route('/')
def index():

    #conn = pymysql.connect(**db_config)
    #cursor = conn.cursor()

    # 센서 데이터 가져오기 (예: 최근 10개)
    #cursor.execute("SELECT id, type, value, created_at FROM sensor_data ORDER BY created_at ASC LIMIT 10;")
    #rows = cursor.fetchall()

    #cursor.close()
    #conn.close()
    #labels = [str(r[3]) for r in rows]  # 날짜/시간
    #data = [r[2] for r in rows]         # 센서값
    #types = [r[1] for r in rows]        # 센서 구분
    rows = [
        (0, "초음파", 100, "2025-09-22 00:00:00"),
        (1, "초음파", 120, "2025-09-22 01:00:00"),
        (2, "초음파", 80, "2025-09-22 02:00:00"),
        (3, "초음파", 140, "2025-09-22 03:00:00"),
        (4, "초음파", 110, "2025-09-22 04:00:00"),
        (5, "초음파", 90, "2025-09-22 05:00:00"),
        (6, "초음파", 100, "2025-09-22 00:00:00"),
        (7, "초음파", 120, "2025-09-22 01:00:00"),
        (8, "초음파", 80, "2025-09-22 02:00:00"),
        (9, "초음파", 140, "2025-09-22 03:00:00"),
        (10, "초음파", 110, "2025-09-22 04:00:00"),		
    ]

    # 차트용 데이터 분리
    labels = [r[3] for r in rows]  # 날짜
    data = [r[2] for r in rows]    # 센서값

    return render_template("iot/index.html", rows=rows, labels=labels, data=data)


    #return render_template("iot/index.html", rows=rows, labels=labels, data=data, types=types)
	